﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

//atrybuty Table i Column
using System.Data.Linq.Mapping;
//DataContext
using System.Data.Linq;
//File, Path
using System.IO;

namespace LINQ_to_SQL
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //tworzenie obiektu DataContext i pobieranie danych z tabeli
            string nazwaPliku = "Telefony.mdf";
            nazwaPliku = Path.GetFullPath(nazwaPliku);
            if (!File.Exists(nazwaPliku))
            {
                MessageBox.Show("Brak pliku " + nazwaPliku);
                return;
            }
            DataContext bazaDanychTelefony = new DataContext(nazwaPliku);
            Table<Osoba> listaOsob = bazaDanychTelefony.GetTable<Osoba>();

            //pobieranie kolekcji
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 select osoba;

            //wyświetlanie pobranej kolekcji
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            //informacje o pobranych danych
            MessageBox.Show("Typ: " + listaOsobPelnoletnich.GetType().FullName);
            MessageBox.Show("Ilość pobranych rekordów: "+listaOsobPelnoletnich.Count().ToString());
            MessageBox.Show("Suma wieku wybranych osób: "+listaOsobPelnoletnich.Sum(osoba=>osoba.Wiek).ToString());
            MessageBox.Show("Imię pierwszej osoby: "+listaOsobPelnoletnich.First().Imię);

            s = "Pełna lista osób:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //tworzenie obiektu DataContext i pobieranie danych z tabeli
            string nazwaPliku = "Telefony.mdf";
            nazwaPliku = Path.GetFullPath(nazwaPliku);
            if (!File.Exists(nazwaPliku))
            {
                MessageBox.Show("Brak pliku " + nazwaPliku);
                return;
            }
            DataContext bazaDanychTelefony = new DataContext(nazwaPliku);
            Table<Osoba> listaOsob = bazaDanychTelefony.GetTable<Osoba>();
            
            //pobieranie kolekcji
            var listaOsobDoZmianyWieku = from osoba in listaOsob where (osoba.Wiek<18 || !osoba.Imię.EndsWith("a")) select osoba;
            
            //wyświetlanie pobranej kolekcji
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobDoZmianyWieku) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            //modyfikowanie kolekcji
            foreach (Osoba osoba in listaOsobDoZmianyWieku) osoba.Wiek++;

            //wyświetlanie pełnej listy osób kolekcji po zmianie
            s = "Lista osób pełnoletnich/mężczyzn:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            //zapisywanie zmian
            bazaDanychTelefony.SubmitChanges();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //tworzenie obiektu DataContext i pobieranie danych z tabeli
            string nazwaPliku = "Telefony.mdf";
            nazwaPliku = Path.GetFullPath(nazwaPliku);
            if (!File.Exists(nazwaPliku))
            {
                MessageBox.Show("Brak pliku " + nazwaPliku);
                return;
            }
            DataContext bazaDanychTelefony = new DataContext(nazwaPliku);
            Table<Osoba> listaOsob = bazaDanychTelefony.GetTable<Osoba>();

            //dodawanie osoby do tabeli
            int noweId = listaOsob.Max(osoba => osoba.Id) + 1;
            MessageBox.Show("Nowe Id: " + noweId);
            Osoba noworodek = new Osoba { Id = noweId, Imię = "Nela", Nazwisko = "Matulewska", NumerTelefonu = 0, Wiek = 0 };
            listaOsob.InsertOnSubmit(noworodek);

            //zapisywanie zmian
            bazaDanychTelefony.SubmitChanges(); //dodawany jest także nowy rekord

            //wyświetlanie tabeli
            string s = "Lista osób:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //tworzenie obiektu DataContext i pobieranie danych z tabeli
            string nazwaPliku = "Telefony.mdf";
            nazwaPliku = Path.GetFullPath(nazwaPliku);
            if (!File.Exists(nazwaPliku))
            {
                MessageBox.Show("Brak pliku " + nazwaPliku);
                return;
            }
            DataContext bazaDanychTelefony = new DataContext(nazwaPliku);
            Table<Osoba> listaOsob = bazaDanychTelefony.GetTable<Osoba>();

            //wybieranie elementów do usunięcia i ich oznaczanie
            IEnumerable<Osoba> doSkasowania = from osoba in listaOsob where osoba.Imię == "Nela" select osoba;
            listaOsob.DeleteAllOnSubmit(doSkasowania);            

            //zapisywanie zmian
            bazaDanychTelefony.SubmitChanges();

            //wyświetlanie tabeli
            string s = "Lista osób:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            //tworzenie obiektu DataContext i pobieranie danych z tabeli
            string nazwaPliku = "Telefony.mdf";
            nazwaPliku = Path.GetFullPath(nazwaPliku);
            if (!File.Exists(nazwaPliku))
            {
                MessageBox.Show("Brak pliku " + nazwaPliku);
                return;
            }
            DataContext bazaDanychTelefony = new DataContext(nazwaPliku);
            //Table<Osoba> listaOsob = bazaDanychTelefony.GetTable<Osoba>();
   
            //lista
        }
    }

    [Table(Name = "ListaOsob")]
    public class Osoba
    {
        [Column(Name = "Id", IsPrimaryKey = true)]
        public int Id;
        [Column(Name = "Imię", CanBeNull = false)]
        public string Imię;
        [Column(Name = "Nazwisko", CanBeNull = false)]
        public string Nazwisko;
        [Column()]
        public int NumerTelefonu;
        [Column()]
        public int Wiek;
    }
}
